<?php

namespace Noptin\Addons_Pack\Users\Triggers;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Fired when someone logs in.
 *
 * @since 1.9.0
 */
class Login extends Abstract_Trigger {

	/**
	 * Constructor.
	 *
	 * @since 1.9.0
	 * @return string
	 */
	public function __construct() {
		add_action( 'wp_login', array( $this, 'wp_login' ), 10, 2 );
	}

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return 'wp_login';
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return __( 'User > Login', 'noptin-addons-pack' );
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return __( 'When someone logs in to their account', 'noptin-addons-pack' );
	}

	/**
	 * When someone logs in to their account
	 *
	 * @param string $user_login  User login.
	 * @param WP_User $user  User object.
	 */
	public function wp_login( $user_login, $user ) {
		$this->trigger( $user, array( 'user_login' => $user_login ) );
	}

}
