# For Developer

## Changes
[list down or summarize the changes here.]

## Screenshots
[If applicable, add screenshots or a link to a loom video to help explain your problem.]

## Notes
[Provide additional explanation on how you implemented your code changes]

## Manual Tests
[Steps to reproduce the behavior and verify that its fixed.]
1. Enable '...'
1. Go to '...'
1. Click on '....'
1. Scroll down to '....'
1. make sure issue is fixed

## Existing automation
[Provide a list of automation feature files that you've run and their results.]

# For Peer Reviewer

## Pre-Review Steps:
- [ ] Pull the branch locally in your test environment

## Code Quality:
- [ ] Check PHPCS and StandardJS in your editor to ensure it reports no problems found
- [ ] Variables are named well and it's clear what they contain based on the naming
- [ ] There are no unused variables
- [ ] There are no dev logging still present (error_log, console.log)
- [ ] DRY principle check – look for add/update situations, look for copy+pasted code, these are situations where code can be abstracted for better maintainability

## Security:
- [ ] SQL statements are using prepare to avoid SQL injections
- [ ] All incoming user input is sanitized using WordPress sanitization functions
- [ ] All printed output containing URLs or printed variable data is escaped using WordPress functions
- [ ] Admin-ajax calls have a nonce passed, and receiving functions are checking the nonce

## Commenting:
- [ ] Function comments are present on all functions (@params, @return, description)
- [ ] `@since` has been added to function header comments for new code added to an existing function or for larger functional changes
- [ ] Larger code blocks have block comments to explain complicated code
- [ ] Inline comments are used for clarity

## Internationalization:
- [ ] All strings are translatable
- [ ] All strings using the correct text domain
- [ ] No translatable strings contain HTML tags
- [ ] Translator comments are present where required

## Exploratory Testing:
- [ ] Pull the changes locally and ensure there are no JS console or PHP error logs shown

### Bugs:
- [ ] Use the steps to replicate, ensure the bug is no longer present
- [ ] Check the additional tests the developer mentions they ran in the issue

### Features/Enhancements:
- [ ] Run through the feature/enhancement and use it as a user would
- [ ] Check the additional tests the developer mentions they ran in the issue

### After going through all issues:
- [ ] Pull the latest automation test cases and run the test for ALL of the affected areas noted across all the issues.

# Test Requirements

Automation tags: `@smoke-test`
Project dependency: default
Third-party dependency: none
WC version: latest
WP version: latest