<?php

namespace Noptin\Addons_Pack\Custom_Fields\Triggers;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Fired when a subscriber is removed from a field.
 *
 * @since 2.0.0
 */
class Remove_From_Field extends Abstract_Trigger {

	/**
	 * @var string
	 */
	public $is_multiple = true;

	/**
	 * @inheritdoc
	 */
	public function attach_hooks() {
		add_action( "noptin_subscriber_removed_from_{$this->merge_tag}", array( $this, 'trigger_set' ), 10, 2 );
	}

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return 'remove_from_' . $this->merge_tag;
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return sprintf(
			/* translators: %s: field label */
			__( 'Subscriber > Removed from %s', 'noptin-addons-pack' ),
			strtolower( $this->label )
		);
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return sprintf(
			/* translators: %s: field label */
			__( 'When a subscriber is removed from %s', 'noptin-addons-pack' ),
			strtolower( $this->label )
		);
	}

	/**
     * Returns an array of known smart tags.
     *
     * @since 1.9.0
     * @return array
     */
    public function get_known_smart_tags() {

		return array_replace(
			array(
				'field_value' => array(
					'description'       => __( 'The removed value', 'noptin-addons-pack' ),
					'example'           => 'field_value',
					'conditional_logic' => 'string',
					'options'           => $this->get_options(),
				),
			),
			parent::get_known_smart_tags()
		);
	}

	/**
	 * Prepares email test data.
	 *
	 * @since 1.11.0
	 * @param Noptin_Automation_Rule $rule
	 * @return Noptin_Automation_Rules_Smart_Tags
	 * @throws Exception
	 */
	public function get_test_smart_tags( $rule ) {

		$subject = noptin_get_subscriber( get_current_noptin_subscriber_id() );
		$args    = $this->prepare_trigger_args( $subject, array( 'field_value' => 'Sample Value' ) );

		return $args['smart_tags'];
	}

}
