<?php

namespace Noptin\Addons_Pack\Custom_Fields\Actions;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Updates a custom field value.
 *
 * @since 2.0.0
 */
class Change_Field extends Abstract_Action {

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return 'change_' . $this->merge_tag;
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return sprintf(
			/* translators: %s: field label */
			__( 'Subscriber > Update %s', 'noptin-addons-pack' ),
			strtolower( $this->label )
		);
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return sprintf(
			/* translators: %s: field label */
			__( 'Updates %s', 'noptin-addons-pack' ),
			strtolower( $this->label )
		);
	}

	/**
	 * @inheritdoc
	 */
	public function get_rule_table_description( $rule ) {
		$settings = $rule->action_settings;

		// Ensure we have a value.
		if ( empty( $settings[ $this->merge_tag ] ) ) {
			return sprintf(
				'<span class="noptin-rule-error">%s</span>',
				esc_html__( 'Error: No value specified', 'noptin-addons-pack' )
			);
		}

		$options = $this->get_options();
		$value   = (string) $settings[ $this->merge_tag ];
		$value   = isset( $options[ $value ] ) ? $options[ $value ] : $value;

		return $this->rule_action_meta(
			array(
				$this->label => esc_html( $value ),
			),
			$rule
		);
	}

	/**
	 * @inheritdoc
	 */
	public function get_settings() {
		return array(

			$this->merge_tag => array(
				'el'      => 'select',
				'label'   => $this->label,
				'options' => $this->get_options(),
				'default' => '',
			),
		);
	}

	/**
	 * @inheritdoc
	 */
	public function run( $subject, $rule, $args ) {

		$subscriber = $this->get_subscriber( $subject, $rule, $args );

		if ( ! $subscriber->exists() ) {
			return;
		}

		// Update the field.
		$subscriber->set( $this->merge_tag, $rule->action_settings[ $this->merge_tag ] );
		$subscriber->save();
	}

}
